/*  String related functions

    Copyright (c) Marty M. Peritsky 1996.
    All Rights Reserved.

    See COPY.TXT for more details.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "copy.h"

// D E F I N E S ////////////////////////////////////////////////////////////

#define TRUE  1
#define FALSE 0

// F U N C T I O N S ////////////////////////////////////////////////////////

void test_heap_err(void *p)
{
    if (p == NULL)
        {
        printf("Insufficient heap space.\n");
        main_exit(1);
        } // end if.

} // end test_heap_err.

/////////////////////////////////////////////////////////////////////////////

char *strcat3(char *a, char *b, char *c)
{
    char *p;

    p=malloc((size_t) (strlen(a)+strlen(b)+strlen(c)+1));
    test_heap_err(p);
    strcpy(p,a);
    strcat(p,b);
    strcat(p,c);
    return p;

} // end strcat3.

/////////////////////////////////////////////////////////////////////////////

char *strdup1(char *a)
{
    char *p;

    p=strdup(a);
    test_heap_err(p);
    return p;

} // end strdup1.

/////////////////////////////////////////////////////////////////////////////

char *str_toupper(char *p)
{
    char *q;

    q=p;
    while (*q != '\0')
        {
        *q=toupper(*q);
        q++;
        } // end while.

    return p;

} // end str_toupper.

/////////////////////////////////////////////////////////////////////////////

int starts_with_plus(char *p)
{
   return ((*p) == '+');

} // end starts_with_plus.

/////////////////////////////////////////////////////////////////////////////

int ends_with_plus(char *p)
{
    size_t len=strlen(p);
    return (len == 0) ? FALSE : (*(p+len-1) == '+');

} // end ends_with_plus.
